package editor;

import java.awt.BorderLayout;
import java.awt.FileDialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;

public class ExportPaletteObjectPanel extends JPanel {
	
	private ExportablesSelectorPanel staticPanel;
	private ExportablesSelectorPanel doorPanel;
	private ExportablesSelectorPanel commentPanel;
	private ExportablesSelectorPanel enemyPanel;
	private ExportablesSelectorPanel widgetPanel;
	
	private JDialog parent;
	
	public ExportPaletteObjectPanel(RoomEditorPanel rep, JDialog theParent) {
		
		parent = theParent;
		
		this.setLayout(new BorderLayout());
		
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new GridLayout(5, 1));
		
		
		staticPanel = new ExportablesSelectorPanel(10, 5, 5, rep);
		JScrollPane staticScroll = new JScrollPane(staticPanel);
//		staticScroll.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
		staticScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED), "Static Blocks"));
		mainPanel.add(staticScroll);
		
		
		doorPanel = new ExportablesSelectorPanel(10, 5, 5, rep);
		JScrollPane doorScroll = new JScrollPane(doorPanel);
//		doorScroll.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
		doorScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED), "Background Widgets"));
		mainPanel.add(doorScroll);
		
		commentPanel = new ExportablesSelectorPanel(10, 5, 5, rep);
		JScrollPane commentScroll = new JScrollPane(commentPanel);
//		commentScroll.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
		commentScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED), "Commentary Widgets"));
		mainPanel.add(commentScroll);
		
		enemyPanel = new ExportablesSelectorPanel(10, 5, 5, rep);
		JScrollPane enemyScroll = new JScrollPane(enemyPanel);
//		enemyScroll.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
		enemyScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED), "Moving/Rogue Blocks and Conveyors"));
		mainPanel.add(enemyScroll);
		
		widgetPanel = new ExportablesSelectorPanel(10, 5, 5, rep);
		JScrollPane widgetScroll = new JScrollPane(widgetPanel);
//		widgetScroll.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
		widgetScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED), "Foreground Widgets"));
		mainPanel.add(widgetScroll);
		
		
		this.add(mainPanel, BorderLayout.CENTER);
		
		
		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new GridLayout(1, 5));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				parent.dispose();
			}
		});
		buttonPanel.add(cancelButton);
		
		buttonPanel.add(new JPanel());
		
		JButton exportAllButton = new JButton("Export All");
		exportAllButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				export(true);
				parent.dispose();
				
			}
		});
		buttonPanel.add(exportAllButton);
		
		buttonPanel.add(new JPanel());
		
		JButton exportButton = new JButton("Export");
		exportButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				export(false);
				parent.dispose();
			}
		});
		buttonPanel.add(exportButton);
		
		this.add(buttonPanel, BorderLayout.SOUTH);
		
		
		
		
	}


	public ExportablesSelectorPanel getStaticPanel() {
		return staticPanel;
	}


	public ExportablesSelectorPanel getDoorPanel() {
		return doorPanel;
	}


	public ExportablesSelectorPanel getCommentPanel() {
		return commentPanel;
	}


	public ExportablesSelectorPanel getEnemyPanel() {
		return enemyPanel;
	}


	public ExportablesSelectorPanel getWidgetPanel() {
		return widgetPanel;
	}
	
	
	
	public void export(boolean everything) {
		
		FileDialog fd = new FileDialog(parent);
		fd.setMode(FileDialog.SAVE);
		fd.setModal(true);
		
		fd.setVisible(true);
		
		if(fd.getFile() == null || fd.getDirectory() == null) {
			return;
		}
		
		
		try {
			BufferedWriter out = new BufferedWriter(new FileWriter(fd.getDirectory() + fd.getFile()));
			
			ArrayList<ExportablePaletteObject> tempList = null;
			
			String tempOutputArray[] = null;
			
			tempList = staticPanel.getList();
			for(ExportablePaletteObject epo : tempList) {
				if(!everything && !epo.isSelected())
					continue;
				tempOutputArray = epo.getOutputArray();
				for(String s : tempOutputArray) {
					out.write(s);
					out.newLine();
				}
				out.newLine();
			}
			
			tempList = doorPanel.getList();
			for(ExportablePaletteObject epo : tempList) {
				if(!everything && !epo.isSelected())
					continue;
				tempOutputArray = epo.getOutputArray();
				for(String s : tempOutputArray) {
					out.write(s);
					out.newLine();
				}
				out.newLine();
			}
			
			out.write("comment_layer:");
			out.newLine();
			out.newLine();
			
			tempList = commentPanel.getList();
			for(ExportablePaletteObject epo : tempList) {
				if(!everything && !epo.isSelected())
					continue;
				tempOutputArray = epo.getOutputArray();
				for(String s : tempOutputArray) {
					out.write(s);
					out.newLine();
				}
				out.newLine();
			}
			
			tempList = enemyPanel.getList();
			for(ExportablePaletteObject epo : tempList) {
				if(!everything && !epo.isSelected())
					continue;
				tempOutputArray = epo.getOutputArray();
				for(String s : tempOutputArray) {
					out.write(s);
					out.newLine();
				}
				out.newLine();
			}
			
			out.write("widget_layer:");
			out.newLine();
			out.newLine();
			
			tempList = widgetPanel.getList();
			for(ExportablePaletteObject epo : tempList) {
				if(!everything && !epo.isSelected())
					continue;
				tempOutputArray = epo.getOutputArray();
				for(String s : tempOutputArray) {
					out.write(s);
					out.newLine();
				}
				out.newLine();
			}
			
			out.flush();
			out.close();
			
			
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
			JOptionPane.showMessageDialog(null, "Error while trying to export: " + e.getMessage(),"Error", JOptionPane.ERROR_MESSAGE);
		}
		
		
		
	}
	
	
	
}
